﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Remoting
{
	public class RProcessor  : IDisposable
	{
		private RMessagePipe Pipe;

		private RActionHandler Handler;

		public event Action<RProcessor, Exception> ExceptionCaught;

		public RProcessor(RMessagePipe pipe, RActionHandler handler)
		{
			Handler = handler;
			Pipe = pipe;
			pipe.MessageReceived += pipe_MessageReceived;
			pipe.ExceptionCaught += pipe_ExceptionCaught;
		}

		void pipe_ExceptionCaught(RMessagePipe pipe, Exception ex)
		{
			Console.WriteLine("{0} is down, exception caught: {1}", pipe, ex);
			if (ExceptionCaught != null)
				ExceptionCaught(this, new Exception("See inner exception.", ex));
		}

		void pipe_MessageReceived(RMessagePipe pipe, RMessage msg)
		{
			// got a message, parse message and invoke method on handler
			try
			{
				Handler.Do(msg.Action, msg.Args);
			}
			catch (Exception ex)
			{
				if (ExceptionCaught != null)
					ExceptionCaught(this, new Exception("See inner exception.", ex));
			}
		}

		public void Do(string action, params object[] args)
		{
			RMessage msg = new RMessage(action, args);
			Pipe.SendMessage(msg);
		}

		public override string ToString()
		{
			return Pipe.ToString();
		}

		#region IDisposable Members

		public void Dispose()
		{
			Pipe.MessageReceived -= pipe_MessageReceived;
			Pipe.ExceptionCaught -= pipe_ExceptionCaught;
			Pipe.Dispose();
		}

		#endregion
	}
}
